#include <algorithm>
#include <array>
#include <bitset>
#include <cassert>
#include <chrono>
#include <cmath>
#include <cstring>
#include <functional>
#include <iomanip>
#include <iostream>
#include <map>
#include <numeric>
#include <queue>
#include <random>
#include <set>
#include <vector>
using namespace std;

#define int long long
#define all(a) (a).begin(), (a).end()
#define rall(a) (a).rbegin(), (a).rend()

struct P {
    int x, y;

    P() : x(0), y(0) {}
    P(int _x, int _y) : x(_x), y(_y) {}

    P operator-(P p) {
        return P(x - p.x, y - p.y);
    }
    // cos
    int operator*(P p) {
        return x * p.x + y * p.y;
    }
    // sin
    int operator%(P p) {
        return x * p.y - y * p.x;
    }
    void scan() {
        cin >> x >> y;
    }
};

int sign(int x) {
    if (x > 0) {
        return 1;
    }
    if (x < 0) {
        return -1;
    }
    return 0;
}

bool is_intersect(P a, P b, P c, P d) {
    return sign((c - a) % (b - a)) * sign((d - a) % (b - a)) <= 0 && sign((a - c) % (d - c)) * sign((b - c) % (d - c)) <= 0 &&
           max(min(a.x, b.x), min(c.x, d.x)) <= min(max(a.x, b.x), max(c.x, d.x)) && max(min(a.y, b.y), min(c.y, d.y)) <= min(max(a.y, b.y), max(c.y, d.y));
}

const int N = 4005;
vector<int> g[N];
int col[N];
int cnt;

void dfs(int v, int p = -1) {
    col[v] = 1;
    for (int u : g[v]) {
        if (u == p) {
            continue;
        }
        if (col[u] == 0) {
            dfs(u, v);
        } else if (col[u] == 1) {
            cnt++;
        }
    }
    col[v] = 2;
}

void solve() {
    int n;
    cin >> n;
    vector<pair<P, P>> seg(n);
    for (int i = 0; i < n; i++) {
        seg[i].first.scan();
        seg[i].second.scan();
    }
    for (int v = 0; v < n; v++) {
        for (int u = v + 1; u < n; u++) {
            if (is_intersect(seg[v].first, seg[v].second, seg[u].first, seg[u].second)) {
                g[v].push_back(u);
                g[u].push_back(v);
//                cout << "edge " << v << ' ' << u << '\n';
            }
        }
    }
    cnt = 0;
    fill(col, col + n, 0);
    for (int v = 0; v < n; v++) {
        if (!col[v]) {
            dfs(v);
        }
    }
    cout << cnt + 1 << '\n';
    for (int v = 0; v < n; v++) {
        g[v].clear();
    }
}

signed main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int tt = 1;
    cin >> tt;
    while (tt--) {
        solve();
    }
}
